%This program is used to compute the whole ATS and its standard error for AR(1) cases by using CUSUM.
%n is the number of subjects
%J is the number of observations for each subject
%L is the total number of time points
%k is the reference value
%limit is the control limit
%n2 out of n1 is the sampling rate
%delta is the shift size

function [AVATS,STDATS,AVANOS,STDANOS]=ATS_Dquality_time(n,J,L,k,limit,n2,n1,delta)
 savfile=['univariate_spc_m_08n',num2str(n),'_J',num2str(J),num2str(L)];
m=textread(['univariate_spc_m_08n',num2str(n),'_J',num2str(J),num2str(L),'.txt']);
mv=textread(['univariate_spc_m_08n',num2str(n),'_J',num2str(J),num2str(L),'var.txt']);
s=sqrt(mv);
z=1+0.3.*([1:L]./L).^0.5;
zz=z+delta*(1-exp(-10*[1:L]./L));
ss=ones(1,L);
N=1000;
ats=zeros(100,N);
ANOS=zeros(100,N);
e=zeros(J,n);

for i=1:100
    [y,x]=getdata_time(n,i,['C:\Users\Terry\Desktop\U of M\quality\rawdataic_for_univariate_spc_', num2str(L)],savfile,L);
     for kk=1:J
     e(kk,:)=(y(kk,:)-m(i,round(L*x(kk,:))))./s(i,round(L*x(kk,:)));
     end
     phi=fminsearch(@(phi) LS_PHI(x,e,phi,L),0.5);
     l=1;
while (l<=N)
 [temp1,temp2]=ATS_Dtime(m(i,:),s(i,:)*sqrt((1-phi^2)),zz,ss,k,limit,phi,n2,n1);
 if temp1<L+1
   ats(i,l)=temp1;
   ANOS(i,l)=temp2;
   l=l+1;
 end
end
end
AVATS=mean(mean(ats'));
STDATS=sqrt(var(mean(ats')))/10;
AVANOS=mean(mean(ANOS'));
STDANOS=sqrt(var(mean(ANOS')))/10;
% MSE=mean((mean(ats')-11).^2);